#include "CvGameCoreDLL.h"
#include "CyPlot.h"
#include "CyCity.h"
#include "CyArea.h"
#include "CyUnit.h"
#include "CvPlot.h"
//# include <boost/python/manage_new_object.hpp>
//# include <boost/python/return_value_policy.hpp>
//
// published python interface for CyPlot
//
void CyPlotPythonInterface1(python::class_<CyPlot>& x)
{
	OutputDebugString("Python Extension Module - CyPlotPythonInterface1\n");
	x
		.def("isNone", &CyPlot::isNone, "bool ()")
		.def("erase", &CyPlot::erase, "void ()")
		.def("getPoint", &CyPlot::getPoint, "NiPoint3 ()")
		.def("getTeam", &CyPlot::getTeam, "int ()")
		.def("updateVisibility", &CyPlot::updateVisibility, "void () Refreshes all of the plots")
		.def("isAdjacentToArea", &CyPlot::isAdjacentToArea, "bool (CyArea)")
		.def("shareAdjacentArea", &CyPlot::shareAdjacentArea, "bool (CyPlot)")
		.def("isAdjacentToLand", &CyPlot::isAdjacentToLand, "bool ()")
		.def("isCoastalLand", &CyPlot::isCoastalLand, "bool ()")
		.def("isWithinTeamCityRadius", &CyPlot::isWithinTeamCityRadius, "bool (int /*TeamTypes*/ eTeam, int /*PlayerTypes*/ eIgnorePlayer)")
		.def("isLake", &CyPlot::isLake, "bool ()")
		.def("isRiverSide", &CyPlot::isRiverSide, "bool ()")
		.def("isRiver", &CyPlot::isRiver, "bool ()")
		.def("isRiverConnection", &CyPlot::isRiverConnection, "bool (int /*DirectionTypes*/ eDirection)")
		.def("getNearestLandArea", &CyPlot::getNearestLandArea, "int ()")
		.def("getNearestLandPlot", &CyPlot::getNearestLandPlot, python::return_value_policy<python::manage_new_object>(), "CyPlot* ()")
		.def("seeFromLevel", &CyPlot::seeFromLevel, "int (int eTeam)")
		.def("seeThroughLevel", &CyPlot::seeThroughLevel, "int ()")
		.def("canHaveBonus", &CyPlot::canHaveBonus, "bool (int /*BonusTypes*/ eBonus, bool bIgnoreLatitude)")
		.def("canHaveImprovement", &CyPlot::canHaveImprovement, "bool (int (ImprovementTypes) eImprovement, int (TeamTypes) eTeam, bool bPotential)")
		.def("canBuild", &CyPlot::canBuild, "bool (int (BuildTypes) eBuild, int (PlayerTypes) ePlayer, bool bTestVisible)")
		.def("getBuildTime", &CyPlot::getBuildTime, "int (int /*BuildTypes*/ eBuild)")
		.def("getBuildTurnsLeft", &CyPlot::getBuildTurnsLeft, "int (int (BuildTypes) eBuild, int iNowExtra, int iThenExtra)")
		.def("getBestDefender", &CyPlot::getBestDefender, python::return_value_policy<python::manage_new_object>(), "CyUnit* (int (PlayerTypes) eOwner, int (PlayerTypes) eAttackingPlayer, CvUnit* pAttacker, bool bTestAtWar, bool bTestPotentialEnemy, bool bTestCanMove)")
		.def("getSelectedUnit", &CyPlot::getSelectedUnit, python::return_value_policy<python::manage_new_object>(), "CyUnit* ()")
		.def("getUnitPower", &CyPlot::getUnitPower, "int (int /*PlayerTypes*/ eOwner)")
		.def("defenseModifier", &CyPlot::defenseModifier, "int (int /*TeamTypes*/, bool bHelp)")
		.def("movementCost", &CyPlot::movementCost, "int (CyUnit* pUnit, CyPlot* pFromPlot)")
		.def("isAdjacentOwned", &CyPlot::isAdjacentOwned, "bool ()")
		.def("isAdjacentPlayer", &CyPlot::isAdjacentPlayer, "bool (int /*PlayerTypes*/ ePlayer, bool bLandOnly)")
		.def("isAdjacentTeam", &CyPlot::isAdjacentTeam, "bool (int /*TeamTypes*/ eTeam, bool bLandOnly)")
		.def("isWithinCultureRange", &CyPlot::isWithinCultureRange, "bool (int /*PlayerTypes*/ ePlayer)")
		.def("getNumCultureRangeCities", &CyPlot::getNumCultureRangeCities, "bool (int /*PlayerTypes*/ ePlayer)")
		.def("calculateCulturalOwner", &CyPlot::calculateCulturalOwner, "int ()")
		.def("isOwned", &CyPlot::isOwned, "bool ()")
		.def("isVisible", &CyPlot::isVisible, "bool (int /*TeamTypes*/ eTeam, bool bDebug)")
		.def("isActiveVisible", &CyPlot::isActiveVisible, "bool (bool bDebug)")
		.def("isVisibleToWatchingHuman", &CyPlot::isVisibleToWatchingHuman, "bool ()")
		.def("isAdjacentVisible", &CyPlot::isAdjacentVisible)
		.def("isAdjacentNonvisible", &CyPlot::isAdjacentNonvisible)
		.def("isAdjacentNonrevealed", &CyPlot::isAdjacentNonrevealed)
		.def("isAdjacentRevealed", &CyPlot::isAdjacentRevealed)
		.def("removeGoody", &CyPlot::removeGoody, "void ()")
		.def("isGoody", &CyPlot::isGoody, "bool ()")
		.def("isRevealedGoody", &CyPlot::isRevealedGoody, "bool (int (TeamTypes) eTeam)")
		.def("isCity", &CyPlot::isCity, "bool ()")
		.def("isFriendlyCity", &CyPlot::isFriendlyCity, "bool (CyUnit* pUnit, bool bCheckImprovement)")
		.def("isEnemyCity", &CyPlot::isEnemyCity, "bool (CyUnit* pUnit)")
		.def("isOccupation", &CyPlot::isOccupation, "bool ()")
		.def("isBeingWorked", &CyPlot::isBeingWorked, "bool ()")
		.def("isUnit", &CyPlot::isUnit, "bool ()")
		.def("isVisibleEnemyDefender", &CyPlot::isVisibleEnemyDefender, "bool (CyUnit* pUnit)")
		.def("getNumDefenders", &CyPlot::getNumDefenders, "int (int /*PlayerTypes*/ ePlayer)")
		.def("getNumVisibleEnemyDefenders", &CyPlot::getNumVisibleEnemyDefenders, "int (CyUnit* pUnit)")
		.def("getNumVisiblePotentialEnemyDefenders", &CyPlot::getNumVisiblePotentialEnemyDefenders, "int (CyUnit* pUnit)")
		.def("isVisibleEnemyUnit", &CyPlot::isVisibleEnemyUnit, "bool (int /*PlayerTypes*/ ePlayer)")
		.def("isVisibleOtherUnit", &CyPlot::isVisibleOtherUnit, "bool (int /*PlayerTypes*/ ePlayer)")
		.def("isFighting", &CyPlot::isFighting, "bool ()")
		.def("canHaveFeature", &CyPlot::canHaveFeature, "bool (int /*FeatureTypes*/ eFeature)")
		.def("isRoute", &CyPlot::isRoute, "bool ()")
		.def("isValidDomainForLocation", &CyPlot::isValidDomainForLocation, "bool (CyUnit* pUnit)")
		.def("isValidDomainForAction", &CyPlot::isValidDomainForAction, "bool (CyUnit* pUnit)")
		.def("isImpassable", &CyPlot::isImpassable, "bool ()")
		.def("getX", &CyPlot::getX, "int ()")
		.def("getY", &CyPlot::getY, "int ()")
		.def("at", &CyPlot::at, "bool (int iX, int iY)")
		.def("getLatitude", &CyPlot::getLatitude, "int ()")
		.def("area", &CyPlot::area, python::return_value_policy<python::manage_new_object>(), "CyArea* ()")
		.def("waterArea", &CyPlot::waterArea, python::return_value_policy<python::manage_new_object>(), "CyArea* ()")
		.def("getArea", &CyPlot::getArea, "int ()")
		.def("getFeatureVariety", &CyPlot::getFeatureVariety, "int ()")
		.def("getOwnershipDuration", &CyPlot::getOwnershipDuration, "int ()")
		.def("isOwnershipScore", &CyPlot::isOwnershipScore, "int ()")
		.def("setOwnershipDuration", &CyPlot::setOwnershipDuration, "int (int iNewValue)")
		.def("changeOwnershipDuration", &CyPlot::changeOwnershipDuration, "int (int iChange)")
		.def("getImprovementDuration", &CyPlot::getImprovementDuration, "int ()")
		.def("setImprovementDuration", &CyPlot::setImprovementDuration, "int (int iNewValue)")
		.def("changeImprovementDuration", &CyPlot::changeImprovementDuration, "int (int iChange)")
		.def("getUpgradeProgress", &CyPlot::getUpgradeProgress, "int ()")
		.def("getUpgradeTimeLeft", &CyPlot::getUpgradeTimeLeft, "int (int /*ImprovementTypes*/ eImprovement, int /*PlayerTypes*/ ePlayer)")
		.def("setUpgradeProgress", &CyPlot::setUpgradeProgress, "void (int iNewValue)")
		.def("changeUpgradeProgress", &CyPlot::changeUpgradeProgress, "void (int iChange)")
		.def("getForceUnownedTimer", &CyPlot::getForceUnownedTimer, "int ()")
		.def("isForceUnowned", &CyPlot::isForceUnowned, "int ()")
		.def("setForceUnownedTimer", &CyPlot::setForceUnownedTimer, "void (int iNewValue)")
		.def("changeForceUnownedTimer", &CyPlot::changeForceUnownedTimer, "void (int iChange)")
		.def("getCityRadiusCount", &CyPlot::getCityRadiusCount, "int ()")
		.def("isCityRadius", &CyPlot::isCityRadius, "int ()")
		.def("isStartingPlot", &CyPlot::isStartingPlot, "bool ()")
		.def("setStartingPlot", &CyPlot::setStartingPlot, "void (bool bNewValue)")
	;
}
